/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminAddRemoveTrackersPanel;
import filenet.vw.toolkit.admin.result.VWAdminDataObjForTrackers;
import filenet.vw.toolkit.admin.result.VWAdminFilteredAddRemoveTrackersPanel;
import filenet.vw.toolkit.admin.result.VWAdminItemInList;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminTrackerDataObject;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class VWAdminManageTrackersDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private VWSession m_session = null;
    private Frame m_parentFrame = null;
    private Vector m_vWobsList = null;
    private Vector m_vWorkflows = null;
    private IVWUsersAndGroupsPanel m_addRemovePanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;

    public VWAdminManageTrackersDialog(VWAdminResultPane resultsPane, Vector wobsList) {
        super(resultsPane.getParentFrame());
        JLabel selectedLabel;
        JLabel availableLabel;
        this.m_session = resultsPane.getSession();
        this.m_parentFrame = resultsPane.getParentFrame();
        this.m_vWobsList = wobsList;
        this.m_vWorkflows = new Vector();
        for (int i = 0; i < this.m_vWobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_vWobsList.elementAt(i);
            if (woData.getWob() == null) continue;
            VWAdminDataObjForTrackers workflowInfo = new VWAdminDataObjForTrackers(woData, resultsPane.getLogonUser(), this.m_session);
            this.m_vWorkflows.addElement(workflowInfo);
        }
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("665,385");
        if (dim == null) {
            dim = new Dimension(600, 350);
        }
        this.setSize(dim);
        this.setTitle(VWResource.s_manageTrackersTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        try {
            this.m_addRemovePanel = this.m_session.getSecurityDatabaseType() == 1 ? new VWAdminFilteredAddRemoveTrackersPanel(this, this.m_session) : new VWAdminAddRemoveTrackersPanel(this.m_session);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.getContentPane().add((Component)((JPanel)((Object)this.m_addRemovePanel)), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.addWindowListener(new VWWindowAdapter(this));
        if (this.m_addRemovePanel instanceof VWAdminFilteredAddRemoveTrackersPanel) {
            ((VWAdminFilteredAddRemoveTrackersPanel)this.m_addRemovePanel).initializeLists(this.getSelectedItems());
        } else if (this.m_addRemovePanel instanceof VWAdminAddRemoveTrackersPanel) {
            ((VWAdminAddRemoveTrackersPanel)this.m_addRemovePanel).initializeLists(this.getSelectedItems());
        }
        if (this.m_addRemovePanel instanceof VWAdminFilteredAddRemoveTrackersPanel) {
            availableLabel = ((VWAdminFilteredAddRemoveTrackersPanel)this.m_addRemovePanel).getAvailableLabel();
            selectedLabel = ((VWAdminFilteredAddRemoveTrackersPanel)this.m_addRemovePanel).getSelectedLabel();
            JList availableJList = ((VWAdminFilteredAddRemoveTrackersPanel)this.m_addRemovePanel).getAvailableJList();
            JList selectedJList = ((VWAdminFilteredAddRemoveTrackersPanel)this.m_addRemovePanel).getSelectedJList();
            VWAccessibilityHelper.setLabelFor(availableLabel, availableJList);
            VWAccessibilityHelper.setLabelFor(selectedLabel, selectedJList);
        } else if (this.m_addRemovePanel instanceof VWAdminAddRemoveTrackersPanel) {
            availableLabel = ((VWAdminAddRemoveTrackersPanel)this.m_addRemovePanel).getAvailableLabel();
            selectedLabel = ((VWAdminAddRemoveTrackersPanel)this.m_addRemovePanel).getSelectedLabel();
            JList availableJList = ((VWAdminAddRemoveTrackersPanel)this.m_addRemovePanel).getAvailableJList();
            JList selectedJList = ((VWAdminAddRemoveTrackersPanel)this.m_addRemovePanel).getSelectedJList();
            VWAccessibilityHelper.setLabelFor(availableLabel, availableJList);
            VWAccessibilityHelper.setLabelFor(selectedLabel, selectedJList);
        }
    }

    public void removeReferences() {
        if (this.m_vWorkflows != null) {
            this.m_vWorkflows.removeAllElements();
        }
        if (this.m_addRemovePanel != null) {
            this.m_addRemovePanel.removeReferences();
            this.m_addRemovePanel = null;
        }
        super.removeReferences();
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_okButton)) {
            this.m_bCanceled = false;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_cancelButton)) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah033.htm");
        }
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    protected Vector getWorkflowDataObjects() {
        return this.m_vWorkflows;
    }

    protected VWAdminItemInList[] getSelectedTrackers() {
        Object[] selectedItems = null;
        VWAdminItemInList[] selectedAdminItems = null;
        if (this.m_addRemovePanel instanceof VWAdminFilteredAddRemoveTrackersPanel) {
            selectedItems = ((VWAdminFilteredAddRemoveTrackersPanel)this.m_addRemovePanel).getSelectedItems();
        } else if (this.m_addRemovePanel instanceof VWAdminAddRemoveTrackersPanel) {
            selectedItems = ((VWAdminAddRemoveTrackersPanel)this.m_addRemovePanel).getSelectedItems();
        }
        if (selectedItems != null) {
            selectedAdminItems = new VWAdminItemInList[selectedItems.length];
            System.arraycopy(selectedItems, 0, selectedAdminItems, 0, selectedItems.length);
        }
        return selectedAdminItems;
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private VWAdminItemInList[] getSelectedItems() {
        Object[] selectedNames = null;
        Vector v_selectedItems = new Vector();
        for (int k = 0; k < this.m_vWorkflows.size(); ++k) {
            VWAdminDataObjForTrackers workflowInfo = (VWAdminDataObjForTrackers)this.m_vWorkflows.elementAt(k);
            this.insertTrackersToSelectedItemsList(v_selectedItems, workflowInfo, true);
        }
        if (v_selectedItems.size() > 0) {
            selectedNames = new VWAdminItemInList[v_selectedItems.size()];
            v_selectedItems.copyInto(selectedNames);
        }
        return selectedNames;
    }

    private void insertTrackersToSelectedItemsList(Vector selectedItems, VWAdminDataObjForTrackers workflowInfo, boolean checkForGray) {
        try {
            Vector v_trackers = workflowInfo.getTrackers();
            for (int i = 0; i < v_trackers.size(); ++i) {
                VWAdminTrackerDataObject trackerInfo = (VWAdminTrackerDataObject)v_trackers.elementAt(i);
                VWParticipant tracker = trackerInfo.getTracker();
                if (this.isInSelectedList(tracker, selectedItems)) continue;
                boolean b_grayedOut = false;
                if (checkForGray && !this.isTrackerInAllWorkflows(trackerInfo)) {
                    b_grayedOut = true;
                }
                VWAdminItemInList item = new VWAdminItemInList(tracker, b_grayedOut);
                selectedItems.addElement(item);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWAdminDataObjForTrackers retrieveWorkflowDataObject(String itemName) {
        if (itemName == null) {
            return null;
        }
        for (int i = 0; i < this.m_vWorkflows.size(); ++i) {
            VWAdminDataObjForTrackers workflowInfo = (VWAdminDataObjForTrackers)this.m_vWorkflows.elementAt(i);
            if (VWStringUtils.compare(workflowInfo.getName(), itemName) != 0) continue;
            return workflowInfo;
        }
        return null;
    }

    private boolean isTrackerInAllWorkflows(VWAdminTrackerDataObject trackerInfo) {
        VWWorkObject trackerWob = null;
        VWParticipant tracker = null;
        try {
            trackerWob = trackerInfo.getWOData().getWob();
            tracker = trackerInfo.getTracker();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        for (int i = 0; i < this.m_vWorkflows.size(); ++i) {
            try {
                VWAdminDataObjForTrackers workflowInfo = (VWAdminDataObjForTrackers)this.m_vWorkflows.elementAt(i);
                VWAdminWorkObjectTableData woData = workflowInfo.getWoData();
                VWWorkObject wob = woData.getWob();
                if (trackerWob.getWorkflowNumber().equals(wob.getWorkflowNumber())) continue;
                boolean bFound = false;
                Vector v_trackers = workflowInfo.getTrackers();
                for (int j = 0; j < v_trackers.size(); ++j) {
                    VWAdminTrackerDataObject item = (VWAdminTrackerDataObject)v_trackers.elementAt(j);
                    if (VWStringUtils.compare(tracker.getParticipantName(), item.getTracker().getParticipantName()) != 0) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                return false;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return true;
    }

    private boolean isInSelectedList(VWParticipant participant, Vector aVector) {
        try {
            if (aVector.size() == 0) {
                return false;
            }
            for (int i = 0; i < aVector.size(); ++i) {
                VWAdminItemInList item = (VWAdminItemInList)aVector.elementAt(i);
                if (VWStringUtils.compare(participant.getParticipantName(), item.getVWParticipant().getParticipantName()) != 0) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }
}

